<?php
/**
 * Newsletter and Ad Section (Combined)
 *
 * @package Multi_Blog_Hub
 * @since 1.0.0
 */

$multi_blog_hub_newsletter_shortcode = get_theme_mod( 'newsletter_shortcode' );
$multi_blog_hub_ed_newsletter        = get_theme_mod( 'ed_newsletter_section', true );
$multi_blog_hub_ad_image             = get_theme_mod( 'newsletter_ad_image' );
?>
<div class="main-container">
	<!-- newsletter -->
	<?php if ( ! $multi_blog_hub_ed_newsletter && is_btnw_activated() && $multi_blog_hub_newsletter_shortcode ) { ?>
		<section id="newsletter_section" class="newsletter-section">
			<div class="container">
				<div class="dt-newsletter-wrapper">
					<div class="left-wrapper">
						<?php
						if ( $multi_blog_hub_newsletter_shortcode ) {
							echo do_shortcode( $multi_blog_hub_newsletter_shortcode );
						}
						?>
					</div>    
					<div class="right-wrapper">
						<?php if ( $multi_blog_hub_ad_image ) { ?>
									<img src="<?php echo esc_url( $multi_blog_hub_ad_image ); ?>" alt="<?php esc_attr_e( 'Advertisement', 'multi-blog-hub' ); ?>" class="newsletter-ad-image" />
						<?php } ?>
					</div>    
				</div>
			</div>
		</section>
	<?php } ?>
	<!-- ad -->
	<?php if ( is_active_sidebar( 'ad-home' ) ) { ?>
	<section class="advertisment-section">
		<div class="container">
			<section id="advertisement" class="advertisment">
				<?php dynamic_sidebar( 'ad-home' ); ?>
			</section>
		</div>
	</section>
	<?php } ?>
</div>
