<?php
if ( ! class_exists( 'Law_Office_Lite_Plugin_Activation_WPElemento_Importer' ) ) {
    /**
     * Law_Office_Lite_Plugin_Activation_WPElemento_Importer initial setup
     *
     * @since 1.6.2
     */

    class Law_Office_Lite_Plugin_Activation_WPElemento_Importer {

        private static $law_office_lite_instance;
        public $law_office_lite_action_count;
        public $law_office_lite_recommended_actions;

        /** Initiator **/
        public static function get_instance() {
          if ( ! isset( self::$law_office_lite_instance) ) {
            self::$law_office_lite_instance = new self();
          }
          return self::$law_office_lite_instance;
        }

        /*  Constructor */
        public function __construct() {

            add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );

            // ---------- wpelementoimpoter Plugin Activation -------
            add_filter( 'law_office_lite_recommended_plugins', array($this, 'law_office_lite_recommended_elemento_importer_plugins_array') );

            $law_office_lite_actions                   = $this->law_office_lite_get_recommended_actions();
            $this->law_office_lite_action_count        = $law_office_lite_actions['count'];
            $this->law_office_lite_recommended_actions = $law_office_lite_actions['actions'];

            add_action( 'wp_ajax_create_pattern_setup_builder', array( $this, 'create_pattern_setup_builder' ) );
        }

        public function law_office_lite_recommended_elemento_importer_plugins_array($law_office_lite_plugins){
            $law_office_lite_plugins[] = array(
                    'name'     => esc_html__('WPElemento Importer', 'law-office-lite'),
                    'slug'     =>  'wpelemento-importer',
                    'function' => 'WPElemento_Importer_ThemeWhizzie',
                    'desc'     => esc_html__('We highly recommend installing the WPElemento Importer plugin for importing the demo content with Elementor.', 'law-office-lite'),               
            );
            return $law_office_lite_plugins;
        }

        public function enqueue_scripts() {
            wp_enqueue_script('updates');      
            wp_register_script( 'law-office-lite-plugin-activation-script', esc_url(get_template_directory_uri()) . '/includes/getstart/js/plugin-activation.js', array('jquery') );
            wp_localize_script('law-office-lite-plugin-activation-script', 'law_office_lite_plugin_activate_plugin',
                array(
                    'installing' => esc_html__('Installing', 'law-office-lite'),
                    'activating' => esc_html__('Activating', 'law-office-lite'),
                    'error' => esc_html__('Error', 'law-office-lite'),
                    'ajax_url' => esc_url(admin_url('admin-ajax.php')),
                    'wpelementoimpoter_admin_url' => esc_url(admin_url('admin.php?page=wpelemento-importer-tgmpa-install-plugins')),
                    'addon_admin_url' => esc_url(admin_url('admin.php?page=wpelementoimporter-wizard'))
                )
            );
            wp_enqueue_script( 'law-office-lite-plugin-activation-script' );

        }

        // --------- Plugin Actions ---------
        public function law_office_lite_get_recommended_actions() {

            $law_office_lite_act_count  = 0;
            $law_office_lite_actions_todo = get_option( 'recommending_actions', array());

            $law_office_lite_plugins = $this->law_office_lite_get_recommended_plugins();

            if ($law_office_lite_plugins) {
                foreach ($law_office_lite_plugins as $law_office_lite_key => $law_office_lite_plugin) {
                    $law_office_lite_action = array();
                    if (!isset($law_office_lite_plugin['slug'])) {
                        continue;
                    }

                    $law_office_lite_action['id']   = 'install_' . $law_office_lite_plugin['slug'];
                    $law_office_lite_action['desc'] = '';
                    if (isset($law_office_lite_plugin['desc'])) {
                        $law_office_lite_action['desc'] = $law_office_lite_plugin['desc'];
                    }

                    $law_office_lite_action['name'] = '';
                    if (isset($law_office_lite_plugin['name'])) {
                        $law_office_lite_action['title'] = $law_office_lite_plugin['name'];
                    }

                    $law_office_lite_link_and_is_done  = $this->law_office_lite_get_plugin_buttion($law_office_lite_plugin['slug'], $law_office_lite_plugin['name'], $law_office_lite_plugin['function']);
                    $law_office_lite_action['link']    = $law_office_lite_link_and_is_done['button'];
                    $law_office_lite_action['is_done'] = $law_office_lite_link_and_is_done['done'];
                    if (!$law_office_lite_action['is_done'] && (!isset($law_office_lite_actions_todo[$law_office_lite_action['id']]) || !$law_office_lite_actions_todo[$law_office_lite_action['id']])) {
                        $law_office_lite_act_count++;
                    }
                    $law_office_lite_recommended_actions[] = $law_office_lite_action;
                    $law_office_lite_actions_todo[]        = array('id' => $law_office_lite_action['id'], 'watch' => true);
                }
                return array('count' => $law_office_lite_act_count, 'actions' => $law_office_lite_recommended_actions);
            }

        }

        public function law_office_lite_get_recommended_plugins() {

            $law_office_lite_plugins = apply_filters('law_office_lite_recommended_plugins', array());
            return $law_office_lite_plugins;
        }

        public function law_office_lite_get_plugin_buttion($slug, $name, $function) {
                $law_office_lite_is_done      = false;
                $law_office_lite_button_html  = '';
                $law_office_lite_is_installed = $this->is_plugin_installed($slug);
                $law_office_lite_plugin_path  = $this->get_plugin_basename_from_slug($slug);
                $law_office_lite_is_activeted = (class_exists($function)) ? true : false;
                if (!$law_office_lite_is_installed) {
                    $law_office_lite_plugin_install_url = add_query_arg(
                        array(
                            'action' => 'install-plugin',
                            'plugin' => $slug,
                        ),
                        self_admin_url('update.php')
                    );
                    $law_office_lite_plugin_install_url = wp_nonce_url($law_office_lite_plugin_install_url, 'install-plugin_' . esc_attr($slug));
                    $law_office_lite_button_html        = sprintf('<a class="law-office-lite-plugin-install install-now button-secondary button" data-slug="%1$s" href="%2$s" aria-label="%3$s" data-name="%4$s">%5$s</a>',
                        esc_attr($slug),
                        esc_url($law_office_lite_plugin_install_url),
                        sprintf(esc_html__('Install %s Now', 'law-office-lite'), esc_html($name)),
                        esc_html($name),
                        esc_html__('Install & Activate', 'law-office-lite')
                    );
                } elseif ($law_office_lite_is_installed && !$law_office_lite_is_activeted) {

                    $law_office_lite_plugin_activate_link = add_query_arg(
                        array(
                            'action'        => 'activate',
                            'plugin'        => rawurlencode($law_office_lite_plugin_path),
                            'plugin_status' => 'all',
                            'paged'         => '1',
                            '_wpnonce'      => wp_create_nonce('activate-plugin_' . $law_office_lite_plugin_path),
                        ), self_admin_url('plugins.php')
                    );

                    $law_office_lite_button_html = sprintf('<a class="law-office-lite-plugin-activate activate-now button-primary button" data-slug="%1$s" href="%2$s" aria-label="%3$s" data-name="%4$s">%5$s</a>',
                        esc_attr($slug),
                        esc_url($law_office_lite_plugin_activate_link),
                        sprintf(esc_html__('Activate %s Now', 'law-office-lite'), esc_html($name)),
                        esc_html($name),
                        esc_html__('Activate', 'law-office-lite')
                    );
                } elseif ($law_office_lite_is_activeted) {
                    $law_office_lite_button_html = sprintf('<div class="action-link button disabled"><span class="dashicons dashicons-yes"></span> %s</div>', esc_html__('Active', 'law-office-lite'));
                    $law_office_lite_is_done     = true;
                }

                return array('done' => $law_office_lite_is_done, 'button' => $law_office_lite_button_html);
            }
        public function is_plugin_installed($slug) {
            $law_office_lite_installed_plugins = $this->get_installed_plugins(); // Retrieve a list of all installed plugins (WP cached).
            $law_office_lite_file_path         = $this->get_plugin_basename_from_slug($slug);
            return (!empty($law_office_lite_installed_plugins[$law_office_lite_file_path]));
        }
        public function get_plugin_basename_from_slug($slug) {
            $law_office_lite_keys = array_keys($this->get_installed_plugins());
            foreach ($law_office_lite_keys as $law_office_lite_key) {
                if (preg_match('|^' . $slug . '/|', $law_office_lite_key)) {
                    return $law_office_lite_key;
                }
            }
            return $slug;
        }

        public function get_installed_plugins() {

            if (!function_exists('get_plugins')) {
                require_once ABSPATH . 'wp-admin/includes/plugin.php';
            }

            return get_plugins();
        }
        public function create_pattern_setup_builder() {

            $edit_page = admin_url().'post-new.php?post_type=page&create_pattern=true';
            echo json_encode(['page_id'=>'','edit_page_url'=> $edit_page ]);

            exit;
        }

    }
}
/**
 * Kicking this off by calling 'get_instance()' method
 */
Law_Office_Lite_Plugin_Activation_WPElemento_Importer::get_instance();