<?php

if ( class_exists("Kirki")){

	Kirki::add_config('theme_config_id', array(
		'capability'   =>  'edit_theme_options',
		'option_type'  =>  'theme_mod',
	));


	Kirki::add_field( 'theme_config_id', [
		'label'       => esc_html__( 'Logo Size','law-office-lite' ),
		'section'     => 'title_tagline',
		'priority'    => 9,
		'type'        => 'range',
		'settings'    => 'logo_size',
		'choices' => [
			'step'             => 5,
			'min'              => 0,
			'max'              => 100,
			'aria-valuemin'    => 0,
			'aria-valuemax'    => 100,
			'aria-valuenow'    => 50,
			'aria-orientation' => 'horizontal',
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_enable_logo_text',
		'section'     => 'title_tagline',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Site Title and Tagline', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

  	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'law_office_lite_display_header_title',
		'label'       => esc_html__( 'Site Title Enable / Disable Button', 'law-office-lite' ),
		'section'     => 'title_tagline',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'law-office-lite' ),
			'off' => esc_html__( 'Disable', 'law-office-lite' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'law_office_lite_display_header_text',
		'label'       => esc_html__( 'Tagline Enable / Disable Button', 'law-office-lite' ),
		'section'     => 'title_tagline',
		'default'     => '0',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'law-office-lite' ),
			'off' => esc_html__( 'Disable', 'law-office-lite' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_site_tittle_font_heading',
		'section'     => 'title_tagline',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Site Title Font Size', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'law_office_lite_site_tittle_font_size',
		'type'        => 'number',
		'section'     => 'title_tagline',
		'transport' => 'auto',
		'output' => array(
			array(
				'element'  => array('.logo a'),
				'property' => 'font-size',
				'suffix' => 'px'
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_site_tagline_font_heading',
		'section'     => 'title_tagline',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Site Tagline Font Size', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'law_office_lite_site_tagline_font_size',
		'type'        => 'number',
		'section'     => 'title_tagline',
		'transport' => 'auto',
		'output' => array(
			array(
				'element'  => array('.logo span'),
				'property' => 'font-size',
				'suffix' => 'px'
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'custom',
		'settings'    => 'law_office_lite_logo_settings_premium_features',
		'section'     => 'title_tagline',
		'priority'    => 50,
		'default'     => '<h3 style="color: #2271b1; padding:5px 20px 5px 20px; background:#fff; margin:0;  box-shadow: 0 2px 4px rgba(0,0,0, .2); ">' . esc_html__( 'Unlock More Features in the Premium Version!', 'law-office-lite' ) . '</h3><ul style="color: #121212; padding: 5px 20px 20px 30px; background:#fff; margin:0;" ><li style="list-style-type: square;" >' . esc_html__( 'Customizable Text Logo', 'law-office-lite' ) . '</li><li style="list-style-type: square;" >'.esc_html__( 'Enhanced Typography Options', 'law-office-lite' ) .'</li><li style="list-style-type: square;" >'.esc_html__( 'Priority Support', 'law-office-lite' ) .'</li><li style="list-style-type: square;" >'.esc_html__( '....and Much More', 'law-office-lite' ) . '</li></ul><div style="background: #fff; padding: 0px 10px 10px 20px;"><a href="' . esc_url( __( 'https://www.wpelemento.com/products/law-office-wordpress-theme', 'law-office-lite' ) ) . '" class="button button-primary" target="_blank">'. esc_html__( 'Upgrade for more', 'law-office-lite' ) .'</a></div>',
	) );


	// Theme color

	Kirki::add_section( 'law_office_lite_theme_color_setting', array(
		'title'    => __( 'Color Option', 'law-office-lite' ),
		'priority' => 10,
	) );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'law_office_lite_first_theme_color',
		'label'       => __( 'Theme First color', 'law-office-lite'),
		'description'    => esc_html__( 'To customize the colors of the homepage, use the Elementor editor', 'law-office-lite' ),
		'section'     => 'law_office_lite_theme_color_setting',
		'type'        => 'color',
		'default'     => '#B68C5A',
	) );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'law_office_lite_second_theme_color',
		'label'       => __( 'Theme Second color', 'law-office-lite'),
		'description'    => esc_html__( 'To customize the colors of the homepage, use the Elementor editor', 'law-office-lite' ),
		'section'     => 'law_office_lite_theme_color_setting',
		'type'        => 'color',
		'default'     => '#000000',
	) );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'law_office_lite_third_theme_color',
		'label'       => __( 'Theme Third color', 'law-office-lite'),
		'description'    => esc_html__( 'To customize the colors of the homepage, use the Elementor editor', 'law-office-lite' ),
		'section'     => 'law_office_lite_theme_color_setting',
		'type'        => 'color',
		'default'     => '#162542',
	) );

	// TYPOGRAPHY SETTINGS

	Kirki::add_panel( 'law_office_lite_typography_panel', array(
		'priority' => 10,
		'title'    => __( 'Typography', 'law-office-lite' ),
	) );

	//Heading 1 Section

	Kirki::add_section( 'law_office_lite_h1_typography_setting', array(
		'title'    => __( 'Heading 1', 'law-office-lite' ),
		'panel'    => 'law_office_lite_typography_panel',
		'priority' => 0,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_h1_typography_heading',
		'section'     => 'law_office_lite_h1_typography_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading 1 Typography', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'  =>  'typography',
		'settings'  => 'law_office_lite_h1_typography_font',
		'section'   =>  'law_office_lite_h1_typography_setting',
		'default'   =>  [
			'font-family'   =>  "'Poppins', sans-serif",
			'variant'       =>  '700',
			'font-size'       => '',
			'line-height'   =>  '',
			'letter-spacing'    =>  '',
			'text-transform'    =>  '',
		],
		'transport'     =>  'auto',
		'output'        =>  [
			[
				'element'   =>  array('.header-image-box h1'),
				'suffix' => '!important'
			],
		],
	) );

	//Heading 2 Section

	Kirki::add_section( 'law_office_lite_h2_typography_setting', array(
		'title'    => __( 'Heading 2', 'law-office-lite' ),
		'panel'    => 'law_office_lite_typography_panel',
		'priority' => 0,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_h2_typography_heading',
		'section'     => 'law_office_lite_h2_typography_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading 2 Typography', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'  =>  'typography',
		'settings'  => 'law_office_lite_h2_typography_font',
		'section'   =>  'law_office_lite_h2_typography_setting',
		'default'   =>  [
			'font-family'   =>  "'Poppins', sans-serif",
			'font-size'       => '',
			'variant'       =>  '700',
			'line-height'   =>  '',
			'letter-spacing'    =>  '',
			'text-transform'    =>  '',
		],
		'transport'     =>  'auto',
		'output'        =>  [
			[
				'element'   =>  'h2'
			],
		],
	) );

	//Heading 3 Section

	Kirki::add_section( 'law_office_lite_h3_typography_setting', array(
		'title'    => __( 'Heading 3', 'law-office-lite' ),
		'panel'    => 'law_office_lite_typography_panel',
		'priority' => 0,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_h3_typography_heading',
		'section'     => 'law_office_lite_h3_typography_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading 3 Typography', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'  =>  'typography',
		'settings'  => 'law_office_lite_h3_typography_font',
		'section'   =>  'law_office_lite_h3_typography_setting',
		'default'   =>  [
			'font-family'   =>  "'Poppins', sans-serif",
			'variant'       =>  '700',
			'font-size'       => '',
			'line-height'   =>  '',
			'letter-spacing'    =>  '',
			'text-transform'    =>  '',
		],
		'transport'     =>  'auto',
		'output'        =>  [
			[
				'element'   =>  'h3',
				'suffix' => '!important'
			],
		],
	) );

	//Heading 4 Section

	Kirki::add_section( 'law_office_lite_h4_typography_setting', array(
		'title'    => __( 'Heading 4', 'law-office-lite' ),
		'panel'    => 'law_office_lite_typography_panel',
		'priority' => 0,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_h4_typography_heading',
		'section'     => 'law_office_lite_h4_typography_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading 4 Typography', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'  =>  'typography',
		'settings'  => 'law_office_lite_h4_typography_font',
		'section'   =>  'law_office_lite_h4_typography_setting',
		'default'   =>  [
			'font-family'   =>  "'Poppins', sans-serif",
			'variant'       =>  '700',
			'font-size'       => '',
			'line-height'   =>  '',
			'letter-spacing'    =>  '',
			'text-transform'    =>  '',
		],
		'transport'     =>  'auto',
		'output'        =>  [
			[
				'element'   =>  'h4',
				'suffix' => '!important'
			],
		],
	) );

	//Heading 5 Section

	Kirki::add_section( 'law_office_lite_h5_typography_setting', array(
		'title'    => __( 'Heading 5', 'law-office-lite' ),
		'panel'    => 'law_office_lite_typography_panel',
		'priority' => 0,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_h5_typography_heading',
		'section'     => 'law_office_lite_h5_typography_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading 5 Typography', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'  =>  'typography',
		'settings'  => 'law_office_lite_h5_typography_font',
		'section'   =>  'law_office_lite_h5_typography_setting',
		'default'   =>  [
			'font-family'   =>  "'Poppins', sans-serif",
			'variant'       =>  '700',
			'font-size'       => '',
			'line-height'   =>  '',
			'letter-spacing'    =>  '',
			'text-transform'    =>  '',
		],
		'transport'     =>  'auto',
		'output'        =>  [
			[
				'element'   =>  'h5',
				'suffix' => '!important'
			],
		],
	) );

	//Heading 6 Section

	Kirki::add_section( 'law_office_lite_h6_typography_setting', array(
		'title'    => __( 'Heading 6', 'law-office-lite' ),
		'panel'    => 'law_office_lite_typography_panel',
		'priority' => 0,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_h6_typography_heading',
		'section'     => 'law_office_lite_h6_typography_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading 6 Typography', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'  =>  'typography',
		'settings'  => 'law_office_lite_h6_typography_font',
		'section'   =>  'law_office_lite_h6_typography_setting',
		'default'   =>  [
			'font-family'   =>  "'Poppins', sans-serif",
			'variant'       =>  '700',
			'font-size'       => '',
			'line-height'   =>  '',
			'letter-spacing'    =>  '',
			'text-transform'    =>  '',
		],
		'transport'     =>  'auto',
		'output'        =>  [
			[
				'element'   =>  'h6',
				'suffix' => '!important'
			],
		],
	) );

	//body Typography

	Kirki::add_section( 'law_office_lite_body_typography_setting', array(
		'title'    => __( 'Content Typography', 'law-office-lite' ),
		'panel'    => 'law_office_lite_typography_panel',
		'priority' => 0,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_body_typography_heading',
		'section'     => 'law_office_lite_body_typography_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Content  Typography', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'  =>  'typography',
		'settings'  => 'law_office_lite_body_typography_font',
		'section'   =>  'law_office_lite_body_typography_setting',
		'default'   =>  [
			'font-family'   =>  "'Mulish', sans-serif",
			'variant'       =>  '',
		],
		'transport'     =>  'auto',
		'output'        =>  [
			[
				'element'   => 'body',
				'suffix' => '!important'
			],
		],
	) );

	//Theme Options Panel

	Kirki::add_panel( 'law_office_lite_theme_options_panel', array(
		'priority' => 10,
		'title'    => __( 'Theme Options', 'law-office-lite' ),
	) );

	// HEADER SECTION

	Kirki::add_section( 'law_office_lite_section_header',array(
		'title' => esc_html__( 'Header Settings', 'law-office-lite' ),
		'description'    => esc_html__( 'Here you can add header information.', 'law-office-lite' ),
		'panel' => 'law_office_lite_theme_options_panel',
		'tabs'  => [
			'header' => [
				'label' => esc_html__( 'Header', 'law-office-lite' ),
			],
			'menu'  => [
				'label' => esc_html__( 'Menu', 'law-office-lite' ),
			],
		],
		'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'menu',
		'settings'    => 'law_office_lite_menu_size_heading',
		'section'     => 'law_office_lite_section_header',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Menu Font Size(px)', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'law_office_lite_menu_size',
		'tab'      => 'menu',
		'label'       => __( 'Enter a value in pixels. Example:20px', 'law-office-lite' ),
		'type'        => 'text',
		'section'     => 'law_office_lite_section_header',
		'transport' => 'auto',
		'output' => array(
			array(
				'element'  => array( '#main-menu a', '#main-menu ul li a', '#main-menu li a'),
				'property' => 'font-size',
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'menu',
		'settings'    => 'law_office_lite_menu_text_transform_heading',
		'section'     => 'law_office_lite_section_header',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Menu Text Transform', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'select',
		'tab'      => 'menu',
		'settings'    => 'law_office_lite_menu_text_transform',
		'section'     => 'law_office_lite_section_header',
		'default'     => 'capitalize',
		'choices'     => [
			'none' => esc_html__( 'Normal', 'law-office-lite' ),
			'uppercase' => esc_html__( 'Uppercase', 'law-office-lite' ),
			'lowercase' => esc_html__( 'Lowercase', 'law-office-lite' ),
			'capitalize' => esc_html__( 'Capitalize', 'law-office-lite' ),
		],
		'output' => array(
			array(
				'element'  => array( '#main-menu a', '#main-menu ul li a', '#main-menu li a'),
				'property' => ' text-transform',
			),
		),
	));



	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'header',
		'settings'    => 'law_office_lite_enable_email_heading',
		'section'     => 'law_office_lite_section_header',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Add Email Address', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'tab'      => 'header',
		'settings' => 'law_office_lite_header_email',
		'section'  => 'law_office_lite_section_header',
		'default'  => '',
		'sanitize_callback' => 'sanitize_email',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'header',
		'settings'    => 'law_office_lite_header_phone_number_heading',
		'section'     => 'law_office_lite_section_header',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Add Phone Number', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'tab'      => 'header',
		'settings' => 'law_office_lite_header_phone_number',
		'section'  => 'law_office_lite_section_header',
		'default'  => '',
		'sanitize_callback' => 'law_office_lite_sanitize_phone_number',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'header',
		'settings'    => 'law_office_lite_header_location_text_heading',
		'section'     => 'law_office_lite_section_header',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Location', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'tab'      => 'header',
		'label'       => esc_html__( 'Location Text', 'law-office-lite' ),
		'settings' => 'law_office_lite_header_location_text',
		'section'  => 'law_office_lite_section_header',
		'default'  => '',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'label'       => esc_html__( 'Location Link', 'law-office-lite' ),
		'tab'      => 'header',
		'settings' => 'law_office_lite_header_location_link',
		'section'  => 'law_office_lite_section_header',
		'default'  => '',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'header',
		'settings'    => 'law_office_lite_header_button_heading',
		'section'     => 'law_office_lite_section_header',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Button', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'tab'      => 'header',
		'label'       => esc_html__( 'Button Text', 'law-office-lite' ),
		'settings' => 'law_office_lite_header_button_text',
		'section'  => 'law_office_lite_section_header',
		'default'  => '',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'label'       => esc_html__( 'Button Link', 'law-office-lite' ),
		'tab'      => 'header',
		'settings' => 'law_office_lite_header_button_link',
		'section'  => 'law_office_lite_section_header',
		'default'  => '',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'header',
		'settings'    => 'law_office_lite_enable_socail_link',
		'priority'       => 11,
		'section'     => 'law_office_lite_section_header',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Social Media Link', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'repeater',
		'tab'      => 'header',
		'section'     => 'law_office_lite_section_header',
		'priority'       => 11,
		'row_label' => [
			'type'  => 'field',
			'value' => esc_html__( 'Social Icon', 'law-office-lite' ),
			'field' => 'link_text',
		],
		'button_label' => esc_html__('Add New Social Icon', 'law-office-lite' ),
		'settings'     => 'law_office_lite_social_links_settings',
		'default'      => '',
		'fields' 	   => [
			'link_text' => [
				'type'        => 'text',
				'label'       => esc_html__( 'Icon', 'law-office-lite' ),
				'description' => esc_html__( 'Add the fontawesome class ex: "fab fa-facebook-f".', 'law-office-lite' ). ' <a href="https://fontawesome.com/v6/search?ic=brands" target="_blank"><strong>' . esc_html__( 'View All', 'law-office-lite' ) . ' </strong></a>',
				'default'     => '',
			],
			'link_url' => [
				'type'        => 'url',
				'label'       => esc_html__( 'Social Link', 'law-office-lite' ),
				'description' => esc_html__( 'Add the social icon url here.', 'law-office-lite' ),
				'default'     => '',
			],
		],
		'choices' => [
			'limit' => 20
		],
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'custom',
		'tab'      => 'header',
		'settings'    => 'law_office_lite_logo_settings_premium_features_header',
		'section'     => 'law_office_lite_section_header',
		'priority'    => 50,
		'default'     => '<h3 style="color: #2271b1; padding:5px 20px 5px 20px; background:#fff; margin:0;  box-shadow: 0 2px 4px rgba(0,0,0, .2); ">' . esc_html__( 'Enhance your header design now!', 'law-office-lite' ) . '</h3><ul style="color: #121212; padding: 5px 20px 20px 30px; background:#fff; margin:0;" ><li style="list-style-type: square;" >' . esc_html__( 'Customize your header background color', 'law-office-lite' ) . '</li><li style="list-style-type: square;" >'.esc_html__( 'Adjust icon and text font sizes', 'law-office-lite' ) .'</li><li style="list-style-type: square;" >'.esc_html__( 'Explore enhanced typography options', 'law-office-lite' ) .'</li><li style="list-style-type: square;" >'.esc_html__( '....and Much More', 'law-office-lite' ) . '</li></ul><div style="background: #fff; padding: 0px 10px 10px 20px;"><a href="' . esc_url( __( 'https://www.wpelemento.com/products/law-office-wordpress-theme', 'law-office-lite' ) ) . '" class="button button-primary" target="_blank">'. esc_html__( 'Upgrade for more', 'law-office-lite' ) .'</a></div>',
	) );

	// WOOCOMMERCE SETTINGS

	Kirki::add_section( 'law_office_lite_woocommerce_settings', array(
		'title'          => esc_html__( 'Woocommerce Settings', 'law-office-lite' ),
		'description'    => esc_html__( 'Woocommerce Settings of themes', 'law-office-lite' ),
		'panel'    => 'woocommerce',
		'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'law_office_lite_shop_page_sidebar',
		'label'       => esc_html__( 'Enable/Disable Shop Page Sidebar', 'law-office-lite' ),
		'section'     => 'law_office_lite_woocommerce_settings',
		'default'     => 'false',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'select',
		'label'       => esc_html__( 'Shop Page Layouts', 'law-office-lite' ),
		'settings'    => 'law_office_lite_shop_page_layout',
		'section'     => 'law_office_lite_woocommerce_settings',
		'default'     => 'Right Sidebar',
		'choices'     => [
			'Right Sidebar' => esc_html__( 'Right Sidebar', 'law-office-lite' ),
			'Left Sidebar' => esc_html__( 'Left Sidebar', 'law-office-lite' ),
		],
		'active_callback'  => [
			[
				'setting'  => 'law_office_lite_shop_page_sidebar',
				'operator' => '===',
				'value'    => true,
			],
		]
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'select',
		'label'       => esc_html__( 'Products Per Row', 'law-office-lite' ),
		'settings'    => 'law_office_lite_products_per_row',
		'section'     => 'law_office_lite_woocommerce_settings',
		'default'     => '4',
		'priority'    => 10,
		'choices'     => [
			'2' => '2',
			'3' => '3',
			'4' => '4',
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'number',
		'label'       => esc_html__( 'Products Per Page', 'law-office-lite' ),
		'settings'    => 'law_office_lite_products_per_page',
		'section'     => 'law_office_lite_woocommerce_settings',
		'default'     => '8',
		'priority'    => 10,
		'choices'  => [
					'min'  => 0,
					'max'  => 50,
					'step' => 1,
				],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'law_office_lite_single_product_sidebar',
		'label'       => esc_html__( 'Enable / Disable Single Product Sidebar', 'law-office-lite' ),
		'section'     => 'law_office_lite_woocommerce_settings',
		'default'     => 'true',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'select',
		'label'       => esc_html__( 'Single Product Layout', 'law-office-lite' ),
		'settings'    => 'law_office_lite_single_product_sidebar_layout',
		'section'     => 'law_office_lite_woocommerce_settings',
		'default'     => 'Right Sidebar',
		'choices'     => [
			'Right Sidebar' => esc_html__( 'Right Sidebar', 'law-office-lite' ),
			'Left Sidebar' => esc_html__( 'Left Sidebar', 'law-office-lite' ),
		],
		'active_callback'  => [
			[
				'setting'  => 'law_office_lite_single_product_sidebar',
				'operator' => '===',
				'value'    => true,
			],
		]
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_products_button_border_radius_heading',
		'section'     => 'law_office_lite_woocommerce_settings',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Products Button Border Radius', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'law_office_lite_products_button_border_radius',
		'section'     => 'law_office_lite_woocommerce_settings',
		'default'     => '1',
		'priority'    => 10,
		'choices'  => [
					'min'  => 1,
					'max'  => 50,
					'step' => 1,
				],
		'output' => array(
			array(
				'element'  => array('.woocommerce ul.products li.product .button',' a.checkout-button.button.alt.wc-forward','.woocommerce #respond input#submit', '.woocommerce a.button', '.woocommerce button.button','.woocommerce input.button','.woocommerce #respond input#submit.alt','.woocommerce button.button.alt','.woocommerce input.button.alt'),
				'property' => 'border-radius',
				'units' => 'px',
			),
		),
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_sale_badge_position_heading',
		'section'     => 'law_office_lite_woocommerce_settings',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Sale Badge Position', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'select',
		'settings'    => 'law_office_lite_sale_badge_position',
		'section'     => 'law_office_lite_woocommerce_settings',
		'default'     => 'right',
		'choices'     => [
			'right' => esc_html__( 'Right', 'law-office-lite' ),
			'left' => esc_html__( 'Left', 'law-office-lite' ),
		],
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_products_sale_font_size_heading',
		'section'     => 'law_office_lite_woocommerce_settings',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Sale Font Size', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'text',
		'settings'    => 'law_office_lite_products_sale_font_size',
		'section'     => 'law_office_lite_woocommerce_settings',
		'priority'    => 10,
		'output' => array(
			array(
				'element'  => array('.woocommerce span.onsale','.woocommerce ul.products li.product .onsale'),
				'property' => 'font-size',
				'units' => 'px',
			),
		),
	] );
	
	//ADDITIONAL SETTINGS

	Kirki::add_section( 'law_office_lite_additional_setting', array(
		'title'          => esc_html__( 'Additional Settings', 'law-office-lite' ),
		'description'    => esc_html__( 'Additional Settings of themes', 'law-office-lite' ),
		'panel'    => 'law_office_lite_theme_options_panel',
		'priority'       => 10,
		'tabs'  => [
			'general' => [
				'label' => esc_html__( 'General', 'law-office-lite' ),
			],
			'header-image'  => [
				'label' => esc_html__( 'Header Image', 'law-office-lite' ),
			],
		],
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'law_office_lite_preloader_hide',
		'label'       => esc_html__( 'Here you can enable or disable your preloader.', 'law-office-lite' ),
		'section'     => 'law_office_lite_additional_setting',
		'default'     => false,
		'priority'    => 10,
		'tab'      => 'general',
	] );
 
	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'law_office_lite_scroll_enable_setting',
		'label'       => esc_html__( 'Here you can enable or disable your scroller.', 'law-office-lite' ),
		'section'     => 'law_office_lite_additional_setting',
		'default'     => true ,
		'priority'    => 10,
		'tab'      => 'general',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'general',
		'settings'    => 'law_office_lite_enable_sidebar_animation_heading',
		'section'     => 'law_office_lite_additional_setting',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Animation', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'general',
		'settings'    => 'law_office_lite_enable_sidebar_animation',
		'label'       => esc_html__( 'Enable or Disable Sidebar Animation', 'law-office-lite' ),
		'section'     => 'law_office_lite_additional_setting',
		'default'     => true,
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'general',
		'settings'    => 'law_office_lite_enable_footer_animation',
		'label'       => esc_html__( 'Enable or Disable Footer Animation', 'law-office-lite' ),
		'section'     => 'law_office_lite_additional_setting',
		'default'     => true,
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'general',
		'settings'    => 'law_office_lite_enable_sidebar_sticky_heading',
		'section'     => 'law_office_lite_additional_setting',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Sticky Sidebar', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'general',
		'settings'    => 'law_office_lite_enable_sticky_sidebar',
		'label'       => esc_html__( 'Enable or Disable Sticky Sidebar', 'law-office-lite' ),
		'section'     => 'law_office_lite_additional_setting',
		'default'     => false,
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'general',
		'settings'    => 'law_office_lite_scroll_alignment_heading',
		'section'     => 'law_office_lite_additional_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Scroll To Top Position', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'radio-buttonset',
		'tab'      => 'general',
		'settings'    => 'law_office_lite_scroll_alignment',
		'section'     => 'law_office_lite_additional_setting',
		'default'     => 'right',
		'choices'     => [
			'left' => esc_html__( 'left', 'law-office-lite' ),
			'center' => esc_html__( 'center', 'law-office-lite' ),
			'right' => esc_html__( 'right', 'law-office-lite' ),
		]
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'general',
		'settings'    => 'law_office_lite_scroller_border_radius_heading',
		'section'     => 'law_office_lite_additional_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Scroll To Top Border Radius', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'slider',
		'tab'      => 'general',
		'settings'    => 'law_office_lite_scroller_border_radius',
		'section'     => 'law_office_lite_additional_setting',
		'default'     => '50',
		'choices'     => [
			'min'  => 0,
			'max'  => 50,
			'step' => 1,
		],
		'output' => array(
			array(
				'element'  => '.scroll-up a',
				'property' => 'border-radius',
				'units' => 'px',
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'general',
		'settings'    => 'law_office_lite_cursor_outline_heading',
		'section'     => 'law_office_lite_additional_setting',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Dot Cursor', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'general',
		'settings'    => 'law_office_lite_cursor_outline',
		'label'       => esc_html__( 'Enable or Disable Dot Cursor', 'law-office-lite' ),
		'section'     => 'law_office_lite_additional_setting',
		'default'     => false,
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'general',
		'settings'    => 'law_office_lite_progress_bar_heading',
		'section'     => 'law_office_lite_additional_setting',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Progress Bar', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'general',
		'settings'    => 'law_office_lite_progress_bar',
		'label'       => esc_html__( 'Enable or Disable Progress Bar', 'law-office-lite' ),
		'section'     => 'law_office_lite_additional_setting',
		'default'     => false,
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'general',
		'settings'    => 'law_office_lite_progress_bar_position_heading',
		'section'     => 'law_office_lite_additional_setting',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Progress Bar Position', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
		'active_callback'  => [
			[
				'setting'  => 'law_office_lite_progress_bar',
				'operator' => '===',
				'value'    => true,
			],
		]
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'select',
		'tab'      => 'general',
		'settings'    => 'law_office_lite_progress_bar_position',
		'section'     => 'law_office_lite_additional_setting',
		'default'     => 'top',
		'choices'     => [
			'top' => esc_html__( 'Top', 'law-office-lite' ),
			'bottom' => esc_html__( 'Bottom', 'law-office-lite' ),
		],
		'active_callback'  => [
			[
				'setting'  => 'law_office_lite_progress_bar',
				'operator' => '===',
				'value'    => true,
			],
		]
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'general',
		'settings'    => 'law_office_lite_progress_bar_color_heading',
		'section'     => 'law_office_lite_additional_setting',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Progress Bar Color', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
		'active_callback'  => [
			[
				'setting'  => 'law_office_lite_progress_bar',
				'operator' => '===',
				'value'    => true,
			],
		]
	] );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'law_office_lite_progress_bar_color',
		'tab'      => 'general',
		'label'       => __( 'Color', 'law-office-lite' ),
		'type'        => 'color',
		'section'     => 'law_office_lite_additional_setting',
		'transport' => 'auto',
		'default'     => '#B68C5A',
		'choices'     => [
			'alpha' => true,
		],
		'output' => array(
			array(
				'element'  => '#elemento-progress-bar',
				'property' => 'background-color',
			),
		),
		'active_callback'  => [
			[
				'setting'  => 'law_office_lite_progress_bar',
				'operator' => '===',
				'value'    => true,
			],
		]
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'general',
		'settings'    => 'law_office_lite_single_page_layout_heading',
		'section'     => 'law_office_lite_additional_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Single Page Layout', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'select',
		'tab'      => 'general',
		'settings'    => 'law_office_lite_single_page_layout',
		'section'     => 'law_office_lite_additional_setting',
		'default'     => 'One Column',
		'choices'     => [
			'Left Sidebar' => esc_html__( 'Left Sidebar', 'law-office-lite' ),
			'Right Sidebar' => esc_html__( 'Right Sidebar', 'law-office-lite' ),
			'One Column' => esc_html__( 'One Column', 'law-office-lite' ),
		],
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'header-image',
		'settings'    => 'law_office_lite_header_background_attachment_heading',
		'section'     => 'law_office_lite_additional_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Header Image Attachment', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'select',
		'tab'      => 'header-image',
		'settings'    => 'law_office_lite_header_background_attachment',
		'section'     => 'law_office_lite_additional_setting',
		'default'     => 'scroll',
		'choices'     => [
			'scroll' => esc_html__( 'Scroll', 'law-office-lite' ),
			'fixed' => esc_html__( 'Fixed', 'law-office-lite' ),
		],
		'output' => array(
			array(
				'element'  => '.header-image-box',
				'property' => 'background-attachment',
			),
		),
	 ) );

	 Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'header-image',
		'settings'    => 'law_office_lite_header_image_height_heading',
		'section'     => 'law_office_lite_additional_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Header Image height', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'law_office_lite_header_image_height',
		'label'       => __( 'Image Height', 'law-office-lite' ),
		'description'    => esc_html__( 'Enter a value in pixels. Example:500px', 'law-office-lite' ),
		'type'        => 'text',
		'tab'      => 'header-image',
		'default'    => [
			'desktop' => '600px',
			'tablet'  => '350px',
			'mobile'  => '200px',
		],
		'responsive' => true,
		'section'     => 'law_office_lite_additional_setting',
		'transport' => 'auto',
		'output' => array(
			array(
				'element'  => array('.header-image-box'),
				'property' => 'height',
				'media_query' => [
					'desktop' => '@media (min-width: 1024px)',
					'tablet'  => '@media (min-width: 768px) and (max-width: 1023px)',
					'mobile'  => '@media (max-width: 767px)',
				],
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'header-image',
		'settings'    => 'law_office_lite_header_overlay_heading',
		'section'     => 'law_office_lite_additional_setting',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Header Image Overlay', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'law_office_lite_header_overlay_setting',
		'tab'      => 'header-image',
		'label'       => __( 'Overlay Color', 'law-office-lite' ),
		'type'        => 'color',
		'section'     => 'law_office_lite_additional_setting',
		'transport' => 'auto',
		'default'     => '#16254291',
		'choices'     => [
			'alpha' => true,
		],
		'output' => array(
			array(
				'element'  => '.header-image-box:before',
				'property' => 'background',
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'header-image',
		'settings'    => 'law_office_lite_header_page_title',
		'label'       => esc_html__( 'Enable / Disable Header Image Page Title.', 'law-office-lite' ),
		'section'     => 'law_office_lite_additional_setting',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'header-image',
		'settings'    => 'law_office_lite_header_breadcrumb',
		'label'       => esc_html__( 'Enable / Disable Header Image Breadcrumb.', 'law-office-lite' ),
		'section'     => 'law_office_lite_additional_setting',
		'default'     => '1',
		'priority'    => 10,
	] );

	// POST SECTION

	Kirki::add_section( 'law_office_lite_blog_post', array(
		'title'          => esc_html__( 'Post Settings', 'law-office-lite' ),
		'description'    => esc_html__( 'Here you can add post information.', 'law-office-lite' ),
		'panel'    => 'law_office_lite_theme_options_panel',
		'tabs'  => [
			'blog-post' => [
				'label' => esc_html__( 'Blog Post', 'law-office-lite' ),
			],
			'single-post'  => [
				'label' => esc_html__( 'Single Post', 'law-office-lite' ),
			],
		],
		'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'blog-post',
		'settings'    => 'law_office_lite_enable_post_animation_heading',
		'section'     => 'law_office_lite_blog_post',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Animation', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'blog-post',
		'settings'    => 'law_office_lite_enable_post_animation',
		'label'       => esc_html__( 'Enable or Disable Blog Post Animation', 'law-office-lite' ),
		'section'     => 'law_office_lite_blog_post',
		'default'     => true,
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'blog-post',
		'settings'    => 'law_office_lite_post_layout_heading',
		'section'     => 'law_office_lite_blog_post',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Blog Layout', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'select',
		'tab'      => 'blog-post',
		'settings'    => 'law_office_lite_post_layout',
		'section'     => 'law_office_lite_blog_post',
		'default'     => 'Right Sidebar',
		'choices'     => [
			'Left Sidebar' => esc_html__( 'Left Sidebar', 'law-office-lite' ),
			'Right Sidebar' => esc_html__( 'Right Sidebar', 'law-office-lite' ),
			'One Column' => esc_html__( 'One Column', 'law-office-lite' ),
			'Three Columns' => esc_html__( 'Three Columns', 'law-office-lite' ),
			'Four Columns' => esc_html__( 'Four Columns', 'law-office-lite' ),
		],
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'blog-post',
		'settings'    => 'law_office_lite_date_hide',
		'label'       => esc_html__( 'Enable / Disable Post Date', 'law-office-lite' ),
		'section'     => 'law_office_lite_blog_post',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'blog-post',
		'settings'    => 'law_office_lite_author_hide',
		'label'       => esc_html__( 'Enable / Disable Post Author', 'law-office-lite' ),
		'section'     => 'law_office_lite_blog_post',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'blog-post',
		'settings'    => 'law_office_lite_comment_hide',
		'label'       => esc_html__( 'Enable / Disable Post Comment', 'law-office-lite' ),
		'section'     => 'law_office_lite_blog_post',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'blog-post',
		'settings'    => 'law_office_lite_blog_post_featured_image',
		'label'       => esc_html__( 'Enable / Disable Post Image', 'law-office-lite' ),
		'section'     => 'law_office_lite_blog_post',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'blog-post',
		'settings'    => 'law_office_lite_length_setting_heading',
		'section'     => 'law_office_lite_blog_post',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Blog Post Content Limit', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'number',
		'tab'      => 'blog-post',
		'settings'    => 'law_office_lite_length_setting',
		'section'     => 'law_office_lite_blog_post',
		'default'     => '15',
		'priority'    => 10,
		'choices'  => [
					'min'  => -10,
					'max'  => 40,
		 			'step' => 1,
				],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'single-post',
		'settings'    => 'law_office_lite_single_post_date_hide',
		'label'       => esc_html__( 'Enable / Disable Single Post Date', 'law-office-lite' ),
		'section'     => 'law_office_lite_blog_post',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'single-post',
		'settings'    => 'law_office_lite_single_post_author_hide',
		'label'       => esc_html__( 'Enable / Disable Single Post Author', 'law-office-lite' ),
		'section'     => 'law_office_lite_blog_post',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'single-post',
		'settings'    => 'law_office_lite_single_post_comment_hide',
		'label'       => esc_html__( 'Enable / Disable Single Post Comment', 'law-office-lite' ),
		'section'     => 'law_office_lite_blog_post',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'single-post',
		'label'       => esc_html__( 'Enable / Disable Single Post Tag', 'law-office-lite' ),
		'settings'    => 'law_office_lite_single_post_tag',
		'section'     => 'law_office_lite_blog_post',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'single-post',
		'label'       => esc_html__( 'Enable / Disable Single Post Category', 'law-office-lite' ),
		'settings'    => 'law_office_lite_single_post_category',
		'section'     => 'law_office_lite_blog_post',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'single-post',
		'settings'    => 'law_office_lite_single_post_featured_image',
		'label'       => esc_html__( 'Enable / Disable Single Post Image', 'law-office-lite' ),
		'section'     => 'law_office_lite_blog_post',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'single-post',
		'settings'    => 'law_office_lite_single_post_radius',
		'section'     => 'law_office_lite_blog_post',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Single Post Image Border Radius(px)', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'law_office_lite_single_post_border_radius',
		'label'       => __( 'Enter a value in pixels. Example:15px', 'law-office-lite' ),
		'type'        => 'text',
		'tab'      => 'single-post',
		'section'     => 'law_office_lite_blog_post',
		'transport' => 'auto',
		'output' => array(
			array(
				'element'  => array('.post-img img'),
				'property' => 'border-radius',
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'tab'      => 'single-post',
		'settings'    => 'law_office_lite_show_related_post_heading',
		'section'     => 'law_office_lite_blog_post',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Related post', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'tab'      => 'single-post',
		'settings'    => 'law_office_lite_show_related_post',
		'label'       => esc_html__( 'Enable or Disable Related post', 'law-office-lite' ),
		'section'     => 'law_office_lite_blog_post',
		'default'     => true,
		'priority'    => 10,
	] );

	// No Results Page Settings

	Kirki::add_section( 'law_office_lite_no_result_section', array(
		'title'          => esc_html__( '404 & No Results Page Settings', 'law-office-lite' ),
		'panel'    => 'law_office_lite_theme_options_panel',
		'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_page_not_found_title_heading',
		'section'     => 'law_office_lite_no_result_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( '404 Page Title', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'law_office_lite_page_not_found_title',
		'section'  => 'law_office_lite_no_result_section',
		'default'  => esc_html__('404 Error!', 'law-office-lite'),
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_page_not_found_text_heading',
		'section'     => 'law_office_lite_no_result_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( '404 Page Text', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'law_office_lite_page_not_found_text',
		'section'  => 'law_office_lite_no_result_section',
		'default'  => esc_html__('The page you are looking for may have been moved, deleted, or possibly never existed.', 'law-office-lite'),
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'     => 'custom',
		'settings' => 'law_office_lite_page_not_found_line_break',
		'section'  => 'law_office_lite_no_result_section',
		'default'  => '<hr>',
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_no_results_title_heading',
		'section'     => 'law_office_lite_no_result_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'No Results Title', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'law_office_lite_no_results_title',
		'section'  => 'law_office_lite_no_result_section',
		'default'  => esc_html__('Nothing Found', 'law-office-lite'),
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_no_results_content_heading',
		'section'     => 'law_office_lite_no_result_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'No Results Content', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'law_office_lite_no_results_content',
		'section'  => 'law_office_lite_no_result_section',
		'default'  => esc_html__('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'law-office-lite'),
	] );
	
	// FOOTER SECTION

	Kirki::add_section( 'law_office_lite_footer_section', array(
        'title'          => esc_html__( 'Footer Settings', 'law-office-lite' ),
        'description'    => esc_html__( 'Here you can change copyright text', 'law-office-lite' ),
        'panel'    => 'law_office_lite_theme_options_panel',
		'priority'       => 160,
    ) );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_show_footer_widget_heading',
		'section'     => 'law_office_lite_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'law_office_lite_show_footer_widget',
		'label'       => esc_html__( 'Footer Widget', 'law-office-lite' ),
		'section'     => 'law_office_lite_footer_section',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'law_office_lite_show_footer_copyright',
		'label'       => esc_html__( 'Footer Copyright', 'law-office-lite' ),
		'section'     => 'law_office_lite_footer_section',
		'default'     => '1',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_footer_text_heading',
		'section'     => 'law_office_lite_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Text', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'law_office_lite_footer_text',
		'section'  => 'law_office_lite_footer_section',
		'default'  => '',
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_footer_sticky_heading',
		'section'     => 'law_office_lite_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Sticky Copyright', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );
	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'law_office_lite_sticky_copyright_enable',
		'label'       => esc_html__( ' Sticky Copyright Section Enable / Disable', 'law-office-lite' ),
		'section'     => 'law_office_lite_footer_section',
		'default'     => '0',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'law-office-lite' ),
			'off' => esc_html__( 'Disable', 'law-office-lite' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_footer_enable_heading',
		'section'     => 'law_office_lite_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Footer Link', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'law_office_lite_copyright_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'law-office-lite' ),
		'section'     => 'law_office_lite_footer_section',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'law-office-lite' ),
			'off' => esc_html__( 'Disable', 'law-office-lite' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_footer_background_widget_heading',
		'section'     => 'law_office_lite_footer_section',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Widget Background', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id',
	[
		'settings'    => 'law_office_lite_footer_background_widget',
		'type'        => 'background',
		'section'     => 'law_office_lite_footer_section',
		'default'     => [
			'background-color'      => 'rgba(23,20,20,1)',
			'background-image'      => '',
			'background-repeat'     => 'no-repeat',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		],
		'transport'   => 'auto',
		'output'      => [
			[
				'element' => '.footer-widget',
			],
		],
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_footer_widget_alignment_heading',
		'section'     => 'law_office_lite_footer_section',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Widget Alignment', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'select',
		'settings'    => 'law_office_lite_footer_widget_alignment',
		'section'     => 'law_office_lite_footer_section',
		'default'     =>[
			'desktop' => 'left',
			'tablet'  => 'left',
			'mobile'  => 'center',
		],
		'responsive' => true,
		'label'       => __( 'Widget Alignment', 'law-office-lite' ),
		'transport' => 'auto',
		'choices'     => [
			'center' => esc_html__( 'center', 'law-office-lite' ),
			'right' => esc_html__( 'right', 'law-office-lite' ),
			'left' => esc_html__( 'left', 'law-office-lite' ),
		],
		'output' => array(
			array(
				'element'  => '.footer-area',
				'property' => 'text-align',
				'media_query' => [
					'desktop' => '@media (min-width: 1024px)',
					'tablet'  => '@media (min-width: 768px) and (max-width: 1023px)',
					'mobile'  => '@media (max-width: 767px)',
				],
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_footer_copright_color_heading',
		'section'     => 'law_office_lite_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Copyright Background Color', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'law_office_lite_footer_copright_color',
		'type'        => 'color',
		'label'       => __( 'Background Color', 'law-office-lite' ),
		'section'     => 'law_office_lite_footer_section',
		'transport' => 'auto',
		'default'     => '#B68C5A',
		'choices'     => [
			'alpha' => true,
		],
		'output' => array(
			array(
				'element'  => '.footer-copyright',
				'property' => 'background',
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_footer_copright_text_color_heading',
		'section'     => 'law_office_lite_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Copyright Text Color', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'law_office_lite_footer_copright_text_color',
		'type'        => 'color',
		'label'       => __( 'Text Color', 'law-office-lite' ),
		'section'     => 'law_office_lite_footer_section',
		'transport' => 'auto',
		'default'     => '#ffffff',
		'choices'     => [
			'alpha' => true,
		],
		'output' => array(
			array(
				'element'  => array( '.footer-copyright a', '.footer-copyright p'),
				'property' => 'color',
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', array(
		'type'        => 'custom',
		'settings'    => 'law_office_lite_logo_settings_premium_features_footer',
		'section'     => 'law_office_lite_footer_section',
		'priority'    => 50,
		'default'     => '<h3 style="color: #2271b1; padding:5px 20px 5px 20px; background:#fff; margin:0;  box-shadow: 0 2px 4px rgba(0,0,0, .2); ">' . esc_html__( 'Elevate your footer with premium features:', 'law-office-lite' ) . '</h3><ul style="color: #121212; padding: 5px 20px 20px 30px; background:#fff; margin:0;" ><li style="list-style-type: square;" >' . esc_html__( 'Tailor your footer layout', 'law-office-lite' ) . '</li><li style="list-style-type: square;" >'.esc_html__( 'Integrate an email subscription form', 'law-office-lite' ) .'</li><li style="list-style-type: square;" >'.esc_html__( 'Personalize social media icons', 'law-office-lite' ) .'</li><li style="list-style-type: square;" >'.esc_html__( '....and Much More', 'law-office-lite' ) . '</li></ul><div style="background: #fff; padding: 0px 10px 10px 20px;"><a href="' . esc_url( __( 'https://www.wpelemento.com/products/law-office-wordpress-theme', 'law-office-lite' ) ) . '" class="button button-primary" target="_blank">'. esc_html__( 'Upgrade for more', 'law-office-lite' ) .'</a></div>',
	) );

	// Footer Social Icons Section

	Kirki::add_section( 'law_office_lite_footer_social_media_section', array(
		'title'          => esc_html__( 'Footer Social Icons', 'law-office-lite' ),
		'panel'    => 'law_office_lite_theme_options_panel',
		'priority'       => 160,
	) );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_footer_social_icon_hide_heading',
		'section'     => 'law_office_lite_footer_social_media_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable or Disable your Footer Social Icon', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'law_office_lite_footer_social_icon_hide',
		'label'       => esc_html__( 'Enable or Disable Social Icon.', 'law-office-lite' ),
		'section'     => 'law_office_lite_footer_social_media_section',
		'default'     => false,
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'law_office_lite_enable_footer_socail_link_align_heading',
		'section'     => 'law_office_lite_footer_social_media_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Social Media Text Align', 'law-office-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', array(
		'settings'    => 'law_office_lite_enable_footer_socail_link_align',
		'type'        => 'select',
		'priority'    => 10,
		'label'       => __( 'Text Align', 'law-office-lite' ),
		'section'     => 'law_office_lite_footer_social_media_section',
		'default'     => 'left',
		'choices'     => [
			'center' => esc_html__( 'center', 'law-office-lite' ),
			'right' => esc_html__( 'right', 'law-office-lite' ),
			'left' => esc_html__( 'left', 'law-office-lite' ),
		],
		'output' => array(
			array(
				'element'  => array( '.footer-links'),
				'property' => 'text-align',
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'priority'    => 10,
		'settings'    => 'law_office_lite_enable_footer_socail_link',
		'section'     => 'law_office_lite_footer_social_media_section',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Social Media Link', 'law-office-lite' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'repeater',
		'priority'    => 10,
		'section'     => 'law_office_lite_footer_social_media_section',
		'row_label' => [
			'type'  => 'field',
			'value' => esc_html__( 'Footer Social Icons', 'law-office-lite' ),
			'field' => 'link_text',
		],
		'button_label' => esc_html__('Add New Social Icon', 'law-office-lite' ),
		'settings'     => 'law_office_lite_social_links_settings_footer',
		'default'      => '',
		'fields' 	   => [
			'link_text' => [
				'type'        => 'text',
				'label'       => esc_html__( 'Icon', 'law-office-lite' ),
				'description' => esc_html__( 'Add the fontawesome class ex: "fab fa-facebook-f".', 'law-office-lite' ). ' <a href="https://fontawesome.com/v6/search?ic=brands" target="_blank"><strong>' . esc_html__( 'View All', 'law-office-lite' ) . ' </strong></a>',
				'default'     => '',
			],
			'link_url' => [
				'type'        => 'url',
				'label'       => esc_html__( 'Social Link', 'law-office-lite' ),
				'description' => esc_html__( 'Add the social icon url here.', 'law-office-lite' ),
				'default'     => '',
			],
		],
		'choices' => [
			'limit' => 20
		],
	] );

	load_template( trailingslashit( get_template_directory() ) . '/includes/logo/logo-resizer.php' );
}
