<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Multi_Blog_Hub
 * @since 1.0.0
 */

?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> itemscope itemtype="https://schema.org/Blog">
	
	<?php
	if ( ! is_front_page() ) {
		echo '<div class="archive-content-wrapper">';}
	?>
	<header class="entry-header">
		<div class="entry-details">
			<?php the_title( '<h4 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' ); ?>
			<div class="entry-content">
				<?php the_excerpt(); ?>
			</div>
		</div>
	</header><!-- .entry-header -->

	<div class="entry-meta-image-wrapper">
		<div class="entry-meta-wrapper">
			<div class="entry-meta">
				<?php good_looking_blog_posted_on(); ?>
			</div><!-- .entry-meta -->
			<div class="author-meta">
				<?php
				echo esc_html__( 'By', 'multi-blog-hub' ) . ' ';
				good_looking_blog_posted_by();
				?>
			</div><!-- .author-meta -->
		</div>

		<div class="image-meta-wrapper">
			<div class="image">
				<?php good_looking_blog_post_thumbnail(); ?>
			</div>
			<div class="entry-meta">
				<?php good_looking_blog_category(); ?>
			</div><!-- .entry-meta -->
		</div>
	</div>
	<?php
	if ( ! is_front_page() ) {
		echo '</div>';}
	?>

</article><!-- #post-<?php the_ID(); ?> -->
