<?php
/**
 * Customizer Settings
 *
 * Overrides and additions to parent theme customizer.
 *
 * @package Multi_Blog_Hub
 * @since 1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Remove unused customizer settings from parent theme.
 *
 * @since 1.0.0
 * @param WP_Customize_Manager $wp_customize WordPress Customizer object.
 */
function multi_blog_hub_remove_unused_settings( $wp_customize ) {
	// Remove sixth "Select Editors post" control.
	if ( $wp_customize->get_control( 'editor_post_six' ) ) {
		$wp_customize->remove_control( 'editor_post_six' );
	}

	// Remove first button (Read More button) - settings and controls.
	if ( $wp_customize->get_control( 'banner_btn_label' ) ) {
		$wp_customize->remove_control( 'banner_btn_label' );
	}

	if ( $wp_customize->get_setting( 'banner_btn_label' ) ) {
		$wp_customize->remove_setting( 'banner_btn_label' );
	}

	if ( $wp_customize->get_control( 'banner_link' ) ) {
		$wp_customize->remove_control( 'banner_link' );
	}

	if ( $wp_customize->get_setting( 'banner_link' ) ) {
		$wp_customize->remove_setting( 'banner_link' );
	}
}
add_action( 'customize_register', 'multi_blog_hub_remove_unused_settings', 999 );

/**
 * Relabel banner button controls in customizer.
 *
 * @since 1.0.0
 * @param WP_Customize_Manager $wp_customize WordPress Customizer object.
 */
function multi_blog_hub_relabel_banner_buttons( $wp_customize ) {

	// Remove the existing "Button 2 Label" control (but keep the setting).
	if ( $wp_customize->get_control( 'banner_btn_two_label' ) ) {
		$wp_customize->remove_control( 'banner_btn_two_label' );

		// Re-add with new label.
		$wp_customize->add_control(
			'banner_btn_two_label',
			array(
				// Changed from "Button 2 Label".
				'label'           => esc_html__( 'Button Label', 'multi-blog-hub' ),
				'section'         => 'header_image',
				'type'            => 'text',
				'active_callback' => 'good_looking_blog_banner_ac',
			)
		);
	}

	// Remove the existing "Button 2 Link" control (but keep the setting).
	if ( $wp_customize->get_control( 'banner_btn_two_link' ) ) {
		$wp_customize->remove_control( 'banner_btn_two_link' );

		// Re-add with new label.
		$wp_customize->add_control(
			'banner_btn_two_link',
			array(
				// Changed from "Button 2 Link".
				'label'           => esc_html__( 'Button Link', 'multi-blog-hub' ),
				'section'         => 'header_image',
				'type'            => 'url',
				'active_callback' => 'good_looking_blog_banner_ac',
			)
		);
	}
}
add_action( 'customize_register', 'multi_blog_hub_relabel_banner_buttons', 999 );

/**
 * Add blog section subtitle setting to customizer.
 *
 * @since 1.0.0
 * @param WP_Customize_Manager $wp_customize WordPress Customizer object.
 */
function multi_blog_hub_add_blog_subtitle_setting( $wp_customize ) {

	$wp_customize->add_setting(
		'blog_section_sub_title',
		array(
			'default'           => esc_html__( 'Most Popular Stories this Week', 'multi-blog-hub' ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		)
	);

	$wp_customize->add_control(
		'blog_section_sub_title',
		array(
			'section' => 'good_looking_blog_blog_posts',
			'label'   => esc_html__( 'Section Sub-title', 'multi-blog-hub' ),
			'type'    => 'text',
		)
	);

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blog_section_sub_title',
			array(
				'selector'        => '.blog-posts-section .section-header h2.section-sub-title',
				'render_callback' => 'good_looking_blog_blog_posts_sub_title',
			)
		);
	}
}
add_action( 'customize_register', 'multi_blog_hub_add_blog_subtitle_setting', 20 );

/**
 * Override theme info links in customizer.
 *
 * @since 1.0.0
 * @param WP_Customize_Manager $wp_customize WordPress Customizer object.
 */
function multi_blog_hub_customize_theme_info( $wp_customize ) {
	// Remove parent's setting and control.
	$wp_customize->remove_setting( 'theme_info_theme' );
	$wp_customize->remove_control( 'theme_info_theme' );

	// Recreate the setting.
	$wp_customize->add_setting(
		'theme_info_theme',
		array(
			'default'           => '',
			'sanitize_callback' => 'wp_kses_post',
		)
	);

	// Build the description HTML with theme URLs.
	$theme_info  = '<ul>';
	$theme_info .= '<li>';
	/* translators: %s: documentation link */
	$theme_info .= sprintf( esc_html__( 'View documentation: %s', 'multi-blog-hub' ), '<a href="' . esc_url( 'https://glthemes.com/documentation/good-looking-blog/' ) . '" target="_blank">' . esc_html__( 'Click here.', 'multi-blog-hub' ) . '</a>' );
	$theme_info .= '</li>';
	$theme_info .= '<li>';
	/* translators: %s: theme info link */
	$theme_info .= sprintf( esc_html__( 'Theme info: %s', 'multi-blog-hub' ), '<a href="' . esc_url( 'https://glthemes.com/wordpress-theme/multi-blog-hub/' ) . '" target="_blank">' . esc_html__( 'Click here.', 'multi-blog-hub' ) . '</a>' );
	$theme_info .= '</li>';
	$theme_info .= '<li>';
	/* translators: %s: support link */
	$theme_info .= sprintf( esc_html__( 'Support ticket: %s', 'multi-blog-hub' ), '<a href="' . esc_url( 'https://glthemes.com/support/' ) . '" target="_blank">' . esc_html__( 'Click here.', 'multi-blog-hub' ) . '</a>' );
	$theme_info .= '</li>';
	$theme_info .= '<li>';
	/* translators: %s: themes link */
	$theme_info .= sprintf( esc_html__( 'More WordPress Themes: %s', 'multi-blog-hub' ), '<a href="' . esc_url( 'https://glthemes.com/wordpress-theme/' ) . '" target="_blank">' . esc_html__( 'Click here.', 'multi-blog-hub' ) . '</a>' );
	$theme_info .= '</li>';
	$theme_info .= '</ul>';

	// Recreate the control with theme's description.
	$wp_customize->add_control(
		new Good_Looking_Blog_Note_Control(
			$wp_customize,
			'theme_info_theme',
			array(
				'label'       => esc_html__( 'Important Links', 'multi-blog-hub' ),
				'section'     => 'theme_info',
				'description' => $theme_info,
			)
		)
	);
}
add_action( 'customize_register', 'multi_blog_hub_customize_theme_info', 999 );

/**
 * Add editors pick section subtitle setting to customizer.
 *
 * @since 1.0.0
 * @param WP_Customize_Manager $wp_customize WordPress Customizer object.
 */
function multi_blog_hub_add_editor_subtitle_setting( $wp_customize ) {

	// Set Hide toggle to priority 1 (appears first).
	$hide_control = $wp_customize->get_control( 'ed_editor_section' );
	if ( $hide_control ) {
		$hide_control->priority = 1;
	}

	// Set Section Title to priority 2.
	$section_title_control = $wp_customize->get_control( 'editor_post_section_title' );
	if ( $section_title_control ) {
		$section_title_control->priority = 2;
	}

	// Add subtitle setting.
	$wp_customize->add_setting(
		'editor_section_sub_title',
		array(
			'default'           => esc_html__( 'Browse the Latest Blogs', 'multi-blog-hub' ),
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'postMessage',
		)
	);

	// Add subtitle control with priority 3 (after Section Title).
	$wp_customize->add_control(
		'editor_section_sub_title',
		array(
			'section'  => 'good_looking_blog_editor_posts',
			'label'    => esc_html__( 'Section sub title', 'multi-blog-hub' ),
			'type'     => 'text',
			'priority' => 3,
		)
	);

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'editor_section_sub_title',
			array(
				'selector'        => '.editors-picks-section .section-header .section-sub-title',
				'render_callback' => 'multi_blog_hub_editor_posts_sub_title',
			)
		);
	}
}
add_action( 'customize_register', 'multi_blog_hub_add_editor_subtitle_setting', 20 );

/**
 * Render callback for editors pick section subtitle.
 *
 * @since 1.0.0
 */
function multi_blog_hub_editor_posts_sub_title() {
	echo esc_html( get_theme_mod( 'editor_section_sub_title', __( 'Browse the Latest Blogs', 'multi-blog-hub' ) ) );
}

/**
 * Add newsletter advertisement image setting to customizer.
 *
 * @since 1.0.0
 * @param WP_Customize_Manager $wp_customize WordPress Customizer object.
 */
function multi_blog_hub_add_newsletter_ad_image( $wp_customize ) {

	// Add setting for the advertisement image.
	$wp_customize->add_setting(
		'newsletter_ad_image',
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_url_raw',
			'transport'         => 'refresh',
		)
	);

	// Add image upload control.
	$wp_customize->add_control(
		new WP_Customize_Image_Control(
			$wp_customize,
			'newsletter_ad_image',
			array(
				'label'       => esc_html__( 'Advertisement Image', 'multi-blog-hub' ),
				'description' => esc_html__( 'Upload an advertisement image for the newsletter section.', 'multi-blog-hub' ),
				'section'     => 'good_looking_blog_newsletter', // Newsletter section.
				'priority'    => 20,
			)
		)
	);
}
add_action( 'customize_register', 'multi_blog_hub_add_newsletter_ad_image', 20 );

/**
 * Override banner defaults to match child theme.
 *
 * @since 1.0.0
 * @param WP_Customize_Manager $wp_customize WordPress Customizer object.
 */
function multi_blog_hub_override_banner_defaults( $wp_customize ) {
	// Override banner_title default.
	$banner_title = $wp_customize->get_setting( 'banner_title' );
	if ( $banner_title ) {
		$banner_title->default = esc_html__( 'Revolutionize Your Travel With These Easy-Peasy Tips', 'multi-blog-hub' );
	}

	// Override banner_content default.
	$banner_content = $wp_customize->get_setting( 'banner_content' );
	if ( $banner_content ) {
		$banner_content->default = esc_html__( 'Travel dates back to antiquity where wealthy Greeks and Romans would travel for leisure to their summer homes and villas in cities such as Pompeii and Baiae.', 'multi-blog-hub' );
	}

	// Override banner_btn_two_label default.
	$banner_btn_two_label = $wp_customize->get_setting( 'banner_btn_two_label' );
	if ( $banner_btn_two_label ) {
		$banner_btn_two_label->default = esc_html__( 'Discover More', 'multi-blog-hub' );
	}
}
add_action( 'customize_register', 'multi_blog_hub_override_banner_defaults', 999 );

/**
 * Remove Homepage Advertisement widget section from Customizer.
 *
 * @since 1.0.1
 *
 * @param WP_Customize_Manager $wp_customize Customizer object.
 */
function multi_blog_hub_remove_home_ad_section( $wp_customize ) {
	// This section corresponds to the "Homepage Advertisement" widget area.
	$wp_customize->remove_section( 'sidebar-widgets-ad-home' );
}
add_action( 'customize_register', 'multi_blog_hub_remove_home_ad_section', 20 );
